/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit source file
*
* Filename:                     tlk_odrm_llf_kmng.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      26.11.2007
*
* Modified:                     26.11.2007
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_ODRM_LLF_KMNG_H_
#define _TLK_ODRM_LLF_KMNG_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "tlk_odrm_types.h"
#include "tlk_cert_types.h"
#include "tlk_sclk_api_types.h"

/*TLK_ODRM_LLF_ProcessRegistration*/
DxError_t TLK_ODRM_LLF_ProcessRegistration( TLK_ODRM_Buffer_t                 * ocspResponse,
										  TLK_ODRM_Buffer_t                   * riCertificate,
										  TLK_ODRM_Buffer_t                   * caCertificate,
										  TLK_CERT_Nonce_t                    * deviceNonce,
										  TLK_SCLK_ServiceClockDescriptor_t   * serviceDescr_ptr, //output
										  DxByte_t                            * workspace_ptr,
										  DxUint32_t                            workspaceSizeInBytes);

/*TLK_ODRM_LLF_ProcessJoinDomain*/
DxError_t TLK_ODRM_LLF_ProcessJoinDomain(TLK_ODRM_Buffer_t                * domainXml,   
										  TLK_ODRM_Key_t				  * deviceKeyRingKey,
										  TLK_ODRM_Key_t				  * devicePrivateKey,
										  TLK_ODRM_Key_t				  * keysRingKey,
										  TLK_ODRM_Key_t				  * DomainKey,
										  DxByte_t                        * workspace_ptr, /*workspace_ptr*/
										  DxUint32_t					    workspaceSizeInBytes); /*workspaceSizeInBytes*/

/*TLK_ODRM_LLF_VerifyDeviceRoBeforeInstall*/
DxError_t TLK_ODRM_LLF_VerifyDeviceRoBeforeInstall(TLK_ODRM_Buffer_t              * roXml_ptr,               
												   TLK_ODRM_Key_t			      * deviceKeyRingKey,
												   TLK_ODRM_Key_t			      * devicePrivateKey,
												   TLK_ODRM_Key_t			      * KeyRingKey,
												   TLK_ODRM_Key_t			      * KmacKey,
												   TLK_ODRM_Key_t			      * KrecKey,                     
												   DxByte_t                       * workspace_ptr,              /*workspace_ptr*/
												   DxUint32_t					    nextWorkspaceSizeInBytes);      /*workspaceSizeInBytes*/

/*TLK_ODRM_LLF_VerifyDeviceRoBeforeInstall*/
DxError_t TLK_ODRM_LLF_VerifyDomainRoBeforeInstall(TLK_ODRM_Buffer_t              * roXml_ptr,               
												   TLK_ODRM_Key_t				  * domainRingKey,
												   TLK_ODRM_Key_t				  * domainKey,
												   TLK_ODRM_DomainGeneration_t      domainGeneration,
												   TLK_ODRM_Key_t				  * KeyRingKey,
												   TLK_ODRM_Key_t				  * KmacKey,
												   TLK_ODRM_Key_t				  * KrecKey,                     
												   DxByte_t                       * workspace_ptr,              /*workspace_ptr*/
												   DxUint32_t                       workspaceSizeInBytes);       /*workspaceSizeInBytes*/
/*TLK_ODRM_LLF_RetrieveKey*/
DxError_t TLK_ODRM_LLF_RetrieveKey( TLK_ODRM_Buffer_t				  * roXml_ptr,
								   TLK_ODRM_Key_t                     * KeyRingKey,                   
								   TLK_ODRM_Key_t                     * KmacKey,              
								   TLK_ODRM_Key_t                     * KrecKey,               
								   const DxChar_t                     * assetId_ptr,
								   TLK_SCLK_ServiceClockDescriptor_t  * serviceDescr_ptr,
								   TLK_ODRM_Buffer_t				  * parentRoXml_ptr,                          
								   TLK_ODRM_Key_t                     * parentKeyRingKey,                       
								   TLK_ODRM_Key_t                     * parentKMacKey,                      
								   TLK_ODRM_Buffer_t                  * groupKey,
								   TLK_ODRM_GROUP_KEY_ENCRYPTION_TYPE    groupKeyEncryptionType,
								   KMNG_AES_WrappedKey_t                contentAesWrappedKey_ptr,
								   DxByte_t                           * workspace_ptr,              /*workspace_ptr*/
								   DxUint32_t                           workspaceSizeInBytes);      /*workspaceSizeInBytes*/




#ifdef __cplusplus
}
#endif       

#endif /*_TLK_ODRM_LLF_KMNG_H_*/
